<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

require_once('libraries/mpdf/mpdf.php');

class Quotes_ExportPDF_Action extends Vtiger_Action_Controller {
	
	public function checkPermission(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		$recordId = $request->get('record');

		if(!Users_Privileges_Model::isPermitted($moduleName, 'DetailView', $recordId)) {
			throw new AppException(vtranslate('LBL_PERMISSION_DENIED', $moduleName));
		}
	}
	
	public function process(Vtiger_Request $request) {
		
		$Iva= $_GET["Iva"];
		
		$viewer = new Vtiger_Viewer;
		global $current_user;
		$current_user->time_zone = 'UTC';
		
		$moduleName = $request->getModule();
		$record = $request->get('record');
		$sourceRecord = $request->get('sourceRecord');
		$sourceModule = $request->get('sourceModule');
		
		if (!empty($record)) {

			$recordModel = Inventory_Record_Model::getInstanceById($record);
			$relatedProducts = $recordModel->getProducts('DetailView');
			
			$potential_id = $recordModel->get('potential_id');
			if (!empty($potential_id)) {
				$focusP =  CRMEntity::getInstance('Potentials');
				$focusP->id = $potential_id;
				$focusP->retrieve_entity_info($potential_id, 'Potentials');
			}
			
			$fecha =  date('Y-m-d');
			$products = array();
			$relatedProducts[1]['final_details']['taxes'][0]['amount'] = 0;
			$relatedProducts[1]['final_details']['taxes'][1]['amount'] = 0;
			$discountTotal = 0;
			for($i =1;$i <= count($relatedProducts);$i++) {
				$category = $relatedProducts[$i]['productcategory'];
				$productName = $relatedProducts[$i]['productName'.$i];
				$qty = $relatedProducts[$i]['qty'.$i];
				$unitPrice = $relatedProducts[$i]['listPrice'.$i];
				$productTotal = $relatedProducts[$i]['productTotal'.$i];
				$comment = $relatedProducts[$i]['comment'.$i];
				
				$discountTotal+= $relatedProducts[$i]['discountTotal'.$i];
				
				if (!isset($products[$category]['total']))
					$products[$category]['total'] = 0;
				if (!isset($products[$category]['tax1']))
					$products[$category]['tax1'] = 0;
				if (!isset($products[$category]['tax2']))
					$products[$category]['tax2'] = 0;
				$products[$category]['total'] += $productTotal;
				$products[$category]['grandTotal']+= $productTotal;
				
				for($j =0;$j <= count($relatedProducts[$i]['taxes']);$j++) {
					if ($relatedProducts[$i]['taxes'][$j]['percentage'] == $relatedProducts[1]['final_details']['taxes'][0]['percentage']) {
						$products[$category]['tax1'] += $relatedProducts[$i]['taxes'][$j]['amount'];
						$relatedProducts[1]['final_details']['taxes'][0]['amount']+=$relatedProducts[$i]['taxes'][$j]['amount'];
					}
					else
					if ($relatedProducts[$i]['taxes'][$j]['percentage'] == $relatedProducts[1]['final_details']['taxes'][1]['percentage']) {
						$products[$category]['tax2'] += $relatedProducts[$i]['taxes'][$j]['amount'];
						$relatedProducts[1]['final_details']['taxes'][1]['amount']+=$relatedProducts[$i]['taxes'][$j]['amount'];
						
					}
					$products[$category]['grandTotal'] +=$relatedProducts[$i]['taxes'][$j]['amount'];
				}
				$productTotal = Vtiger_Currency_UIType::transformDisplayValue($productTotal, null, true);
				$unitPrice = Vtiger_Currency_UIType::transformDisplayValue($unitPrice, null, true);
				
				$products[$category]['products'][] = array('productName'=>$productName,
										'qty'=> $qty,
										'unitPrice'=>$unitPrice,
														   'productTotal' => $productTotal,
														   'comment' => $comment);
			}
			$discountTotal+= $relatedProducts[1]['final_details']['adjustment'];
			
			$relatedProducts[1]['final_details']['hdnSubTotal'] = $relatedProducts[1]['final_details']['hdnSubTotal'] - $relatedProducts[1]['final_details']['adjustment'];	
			
			
			$relatedProducts[1]['final_details']['preTaxTotal'] = $relatedProducts[1]['final_details']['grandTotal'] -$relatedProducts[1]['final_details']['taxes'][0]['amount']-$relatedProducts[1]['final_details']['taxes'][1]['amount'];
			$relatedProducts[1]['final_details']['taxTotal'] = $relatedProducts[1]['final_details']['taxes'][0]['amount']+$relatedProducts[1]['final_details']['taxes'][1]['amount'];
			$relatedProducts[1]['final_details']['discountTotal_final'] = Vtiger_Currency_UIType::transformDisplayValue($discountTotal, null, true);
			$relatedProducts[1]['final_details']['hdnSubTotal'] = Vtiger_Currency_UIType::transformDisplayValue($relatedProducts[1]['final_details']['hdnSubTotal'], null, true);
			$relatedProducts[1]['final_details']['tax_totalamount'] = Vtiger_Currency_UIType::transformDisplayValue($relatedProducts[1]['final_details']['tax_totalamount'], null, true);
			$relatedProducts[1]['final_details']['grandTotal'] = Vtiger_Currency_UIType::transformDisplayValue($relatedProducts[1]['final_details']['grandTotal'], null, true);
			$days = array('Lunes','Martes','Mircoles','Jueves','Viernes','Sbado','Domingo');
			$viewer->assign('FECHA',  DateTimeField::convertToUserFormat($fecha));
			$viewer->assign('SUBJECT',  getContactName($recordModel->get('contact_id')).' / '.$recordModel->get('subject'));
			$viewer->assign('QUOTE_NO',  $recordModel->get('quote_no'));
			$viewer->assign('PROD_BY_CATEGORY',$products);
			$viewer->assign('RELATED_PRODUCTS',$relatedProducts);
			$viewer->assign('NUMADULTOS',$focusP->column_fields['cf_759']);
			$viewer->assign('NUMNINOS',$focusP->column_fields['cf_771']);
			$dateEvent = new DateTimeField($focusP->column_fields['cf_761']);
			$viewer->assign('DATEEVENT',$dateEvent->getDisplayDate());
			$day = date('N',strtotime($focusP->column_fields['cf_761']));
			$viewer->assign('DIAEVENT',$days[($day-1)]);
			$viewer->assign('HORAEVENT',$focusP->column_fields['cf_773']);
			$viewer->assign('WHISKY', number_format($recordModel->get('cf_793'),0));
			$viewer->assign('VODKA', number_format($recordModel->get('cf_795'),0));
			$viewer->assign('TRAGOS', $recordModel->get('cf_797'));
			$viewer->assign('IVA', $Iva);
						
			$buffer = $viewer->view('ExportPDF.tpl', $moduleName,true);
			
			$header = '';
		} 
		$footer = '';
		
		$mpdf=new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9);
		$mpdf->SetTitle('OPORTUNIDAD');
	//	$mpdf->useSubstitutions = true; // optional - just as an example
		$mpdf->setAutoTopMargin = 'stretch'; 
		$mpdf->setAutoBottomMargin = 'stretch'; 
	//	$mpdf->SetHTMLHeader ($header);  // optional - just as an example
		$mpdf->SetHTMLFooter ($footer);
	//	$mpdf->setBasePath($url);
		$mpdf->WriteHTML($buffer);
		$mpdf->Output('OPORTUNIDAD.pdf','I');
		exit;
	}
}
